function writecolormap( cmap, filename )
% writecolormap( cmap, filename )
% 
% Writes the colour map as a PNG file, the file has two columns of pixels.
% The user can change the colour of pixels in the right column, using an
% image editing program, like the Gimp or Photoshop. The matlab function importeditedcolormap
% can be used to read in the edited colour map, and convert it into a
% matlab colourmap, which can be used to save the gif with the new colours
% using imwrite.
% 
% See also importeditedcolormap, showcolormap, imwrite


imwrite( repmat( reshape(cmap, length(cmap) ,1,3), 1,2), filename);